#include <stdio.h>
#include <common_func_netx500.h>
#include <libc_file_support.h>
#include <libc_mem_support.h>
#include <ToolkitSample.h>
#include <OS_Spi.h>

#define SERDPM_SLAVE 1

static NX500_SPI_AREA_T* s_ptSpi = (NX500_SPI_AREA_T*) NX500_NETX_SPI_AREA;

/*****************************************************************************/
/*! Assert chip select
*   \param pvOSDependent OS Dependent parameter to identify card             */
/*****************************************************************************/
void OS_SpiAssert(void* pvOSDependent)
{
  /* Clear tx/rx FIFO */
  s_ptSpi->ulSpi_control_register |= (MSK_NX500_spi_control_register_CR_clr_infifo | MSK_NX500_spi_control_register_CR_clr_outfifo );
  /* assert chip select */
  s_ptSpi->ulSpi_control_register |= (1 << (SRT_NX500_spi_control_register_CR_ss+SERDPM_SLAVE));
}

/*****************************************************************************/
/*! Deassert chip select
*   \param pvOSDependent OS Dependent parameter to identify card             */
/*****************************************************************************/
void OS_SpiDeassert(void* pvOSDependent)
{
  s_ptSpi->ulSpi_control_register &= ~(1 << (SRT_NX500_spi_control_register_CR_ss+SERDPM_SLAVE));
}

/*****************************************************************************/
/*! Transfer byte stream via SPI
*   \param pvOSDependent OS Dependent parameter to identify card
*   \param pbSend        Send buffer (NULL for polling)
*   \param pbRecv        Receive buffer (NULL if discard)
*   \param ulLen         Length of SPI transfer                              */
/*****************************************************************************/
void OS_SpiTransfer(void* pvOSDependent, uint8_t* pbSend, uint8_t* pbRecv, uint32_t ulLen)
{
  uint32_t ulOutFuel;

  while (ulLen--)
  {
    /* write byte to spi bus */
    if (pbSend == NULL)
      s_ptSpi->ulSpi_data_register = MSK_NX500_spi_data_register_dr_valid0;
    else
      s_ptSpi->ulSpi_data_register = *(pbSend++) | MSK_NX500_spi_data_register_dr_valid0;

    /* wait until all bytes are clocked out. There will be a byte in the
     * receive buffer.  */
    do
    {
      ulOutFuel   = s_ptSpi->ulSpi_status_register & MSK_NX500_spi_status_register_SR_out_fuel_val;
    } while( ulOutFuel!=0 );

    /* get the received byte */
    if (pbRecv == NULL)
      s_ptSpi->ulSpi_data_register;
    else
      *(pbRecv++) = s_ptSpi->ulSpi_data_register & MSK_NX500_spi_data_register_data_byte_0;
  }
}

int main()
{
  /* Init MMU */
  NX500_MMU_Init((unsigned long*)0x1C000);

  /* Libc memory initialiation */
  libc_mem_init();
  
  /* Init the libc part & redirect printf output to uart */
  libc_file_init();
 
  /* soft reset spi and clear both fifos */
  s_ptSpi->ulSpi_control_register = MSK_NX500_spi_control_register_CR_softreset  |
                                    MSK_NX500_spi_control_register_CR_clr_infifo |
                                    MSK_NX500_spi_control_register_CR_clr_outfifo;

  /* setup SPI Core data width and enable static nCS handling */
  s_ptSpi->ulSpi_control_register  = 7 << SRT_NX500_spi_control_register_CR_burst;

  /* set clock to 12,5MHz*/
  s_ptSpi->ulSpi_control_register |= (12 << SRT_NX500_spi_control_register_CR_speed);

  /* SPI Mode 3 */
  s_ptSpi->ulSpi_control_register |= MSK_NX500_spi_control_register_CR_cpol;

  s_ptSpi->ulSpi_control_register |= MSK_NX500_spi_control_register_CR_ms |
                                     MSK_NX500_spi_control_register_CR_en |
                                     MSK_NX500_spi_control_register_CR_read |
                                     MSK_NX500_spi_control_register_CR_write;

  /* reset status bits */
  s_ptSpi->ulSpi_status_register = 0;

  /* do not use irqs for now */
  s_ptSpi->ulSpi_interrupt_control_register = 0;
        
  ToolkitSample();
  
  while (1);
}